/* E-Facturation France — Admin JS */
(function($) {
    'use strict';

    /* ---- Checkout: Toggle B2B fields ---- */
    function toggleB2B() {
        var show = $('#billing_is_business').is(':checked');
        if (show) {
            $('.wcef-b2b-field').addClass('visible');
            if (!$('.wcef-b2b-fields-group').length) {
                $('.wcef-b2b-field').wrapAll('<div class="wcef-b2b-fields-group">');
            }
        } else {
            $('.wcef-b2b-field').removeClass('visible');
        }
    }

    $(document.body).on('change', '#billing_is_business', toggleB2B);
    $(function() { toggleB2B(); });

    /* ---- Order Meta Box: Generate invoice ---- */
    $(document.body).on('click', '.wcef-generate-btn', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var orderId = $btn.data('order-id');
        if (!orderId || $btn.prop('disabled')) return;

        $btn.prop('disabled', true).text('Generation en cours...');

        $.post(wcef.ajax_url, {
            action: 'wcef_generate_invoice',
            nonce: wcef.nonce,
            order_id: orderId
        }, function(response) {
            if (response.success) {
                location.reload();
            } else {
                $btn.prop('disabled', false).text('Generer la facture');
                alert('Erreur : ' + (response.data || 'Erreur inconnue'));
            }
        }).fail(function() {
            $btn.prop('disabled', false).text('Generer la facture');
            alert('Erreur de connexion.');
        });
    });

    /* ---- Dismiss upgrade banner ---- */
    $(document.body).on('click', '.wcef-dismiss-banner', function(e) {
        e.preventDefault();
        $(this).closest('.wcef-upgrade-banner').slideUp(200);
        $.post(wcef.ajax_url, {
            action: 'wcef_dismiss_banner',
            nonce: wcef.nonce
        });
    });

    /* ---- License: Activate ---- */
    $(document.body).on('click', '#wcef-activate-license', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var key = $('#wcef_license_key').val().trim();
        if (!key) {
            $('#wcef-license-msg').html('<span style="color:var(--wcef-red)">Veuillez entrer une cle de licence.</span>');
            return;
        }

        $btn.prop('disabled', true).text('Verification...');

        $.post(wcef.ajax_url, {
            action: 'wcef_verify_license',
            nonce: wcef.nonce,
            license_key: key
        }, function(response) {
            if (response.success) {
                var labels = { starter: 'Gratuit', core: 'Gratuit', partner: 'Agence' };
                var routingLabels = { none: '', routing_s: 'Essentiel', routing_m: 'Business', routing_l: 'Premium', routing_xl: 'Agence' };
                var plan = response.data.plan;
                var routing = response.data.routing || 'none';
                var fullLabel = (routing !== 'none' && routingLabels[routing]) ? routingLabels[routing] : (labels[plan] || plan);
                $('#wcef-license-msg').html('<span style="color:var(--wcef-green);font-weight:600">Licence activee — ' + fullLabel + '</span>');
                // Reload to update UI fully.
                setTimeout(function() { location.reload(); }, 1500);
            } else {
                $('#wcef-license-msg').html('<span style="color:var(--wcef-red)">' + (response.data || 'Licence invalide.') + '</span>');
                $btn.prop('disabled', false).text('Activer');
            }
        }).fail(function() {
            $('#wcef-license-msg').html('<span style="color:var(--wcef-red)">Erreur de connexion.</span>');
            $btn.prop('disabled', false).text('Activer');
        });
    });

    /* ---- License: Deactivate ---- */
    $(document.body).on('click', '#wcef-deactivate-license', function(e) {
        e.preventDefault();
        if (!confirm('Desactiver votre licence ? Vous repasserez au plan Gratuit.')) return;

        var $btn = $(this);
        $btn.prop('disabled', true);

        $.post(wcef.ajax_url, {
            action: 'wcef_deactivate_license',
            nonce: wcef.nonce
        }, function(response) {
            if (response.success) {
                $('#wcef_license_key').val('');
                $('#wcef-license-msg').html('Licence desactivee. <a href="https://efacturx.com/#tarifs" target="_blank" style="color:var(--wcef-primary);font-weight:600">Voir les offres</a>');
                setTimeout(function() { location.reload(); }, 1000);
            }
        });
    });

    /* ---- Settings: AJAX Save ---- */
    $(document.body).on('submit', '#wcef-settings-form', function(e) {
        e.preventDefault();
        var $form = $(this);
        var $btn = $('#wcef-save-btn');
        var $status = $('#wcef-save-status');

        $btn.prop('disabled', true).text('Enregistrement...');
        $status.removeClass('visible').text('');

        var data = $form.serialize();
        data += '&action=wcef_save_settings&nonce=' + wcef.nonce;

        $.post(wcef.ajax_url, data, function(response) {
            $btn.prop('disabled', false).text('Enregistrer les reglages');
            if (response.success) {
                $status.text('Reglages enregistres').addClass('visible');
                setTimeout(function() { $status.removeClass('visible'); }, 3000);
                // Refresh preview after saving.
                if ($('#wcef-preview-container').length) {
                    loadPreview();
                }
            } else {
                $status.css('color', 'var(--wcef-red)').text('Erreur : ' + (response.data || 'Erreur inconnue')).addClass('visible');
            }
        }).fail(function() {
            $btn.prop('disabled', false).text('Enregistrer les reglages');
            $status.css('color', 'var(--wcef-red)').text('Erreur de connexion').addClass('visible');
        });
    });

    /* ---- Settings: Media Library Logo Picker ---- */
    var wcefMediaFrame;
    $(document.body).on('click', '.wcef-select-logo', function(e) {
        e.preventDefault();
        if (wcefMediaFrame) {
            wcefMediaFrame.open();
            return;
        }
        wcefMediaFrame = wp.media({
            title: 'Choisir un logo',
            button: { text: 'Utiliser ce logo' },
            multiple: false,
            library: { type: 'image' }
        });
        wcefMediaFrame.on('select', function() {
            var attachment = wcefMediaFrame.state().get('selection').first().toJSON();
            $('#wcef_logo_id').val(attachment.id).trigger('change');
            var thumbUrl = attachment.sizes && attachment.sizes.thumbnail ? attachment.sizes.thumbnail.url : attachment.url;
            $('#wcef-logo-preview').html('<img src="' + thumbUrl + '" alt="Logo">');
            if (!$('.wcef-remove-logo').length) {
                $('.wcef-select-logo').after(' <button type="button" class="button wcef-remove-logo">Supprimer</button>');
            }
            $('.wcef-select-logo').text('Changer');
        });
        wcefMediaFrame.open();
    });

    $(document.body).on('click', '.wcef-remove-logo', function(e) {
        e.preventDefault();
        $('#wcef_logo_id').val('0').trigger('change');
        $('#wcef-logo-preview').html('');
        $('.wcef-select-logo').text('Choisir un logo');
        $(this).remove();
    });

    /* ---- Settings: VAT regime preview ---- */
    $(document.body).on('change', '#wcef_vat_regime', function() {
        var regime = $(this).val();
        var previews = {
            'standard': '',
            'franchise': 'Mention sur la facture : \u00AB TVA non applicable, art. 293 B du CGI \u00BB',
            'autoliquid': 'Mention sur la facture : \u00AB Autoliquidation - TVA due par le preneur \u00BB',
            'intra': 'Mention sur la facture : \u00AB Exoneration TVA, art. 262 ter-I du CGI \u00BB',
            'export': 'Mention sur la facture : \u00AB Exoneration TVA, art. 262-I du CGI \u00BB'
        };
        var text = previews[regime] || '';
        var $preview = $('#wcef-vat-preview');
        if (text) {
            $preview.html('<div class="wcef-vat-preview-text">' + text + '</div>');
        } else {
            $preview.html('');
        }
    });

    /* ---- Stats counter animation ---- */
    $(function() {
        $('.wcef-stat-card .stat-value').each(function() {
            var $el = $(this);
            var text = $el.text().trim();
            var match = text.match(/([\d\s,.]+)/);
            if (!match) return;
            var target = parseFloat(match[1].replace(/\s/g, '').replace(',', '.'));
            if (isNaN(target) || target === 0) return;
            var suffix = text.replace(match[1], '');
            var decimals = (match[1].indexOf(',') > -1 || match[1].indexOf('.') > -1) ? 2 : 0;
            $({val: 0}).animate({val: target}, {
                duration: 600,
                easing: 'swing',
                step: function() {
                    var v = decimals ? this.val.toFixed(2).replace('.', ',') : Math.floor(this.val);
                    $el.text(v.toLocaleString('fr-FR') + suffix);
                },
                complete: function() {
                    $el.text(text);
                }
            });
        });
    });

    /* ============================================
       LIVE PDF PREVIEW (all settings tabs)
       ============================================ */

    var previewTimer = null;

    function buildPreviewUrl() {
        var base = wcef.ajax_url + '?action=wcef_preview_pdf&nonce=' + encodeURIComponent(wcef.nonce) + '&_t=' + Date.now();

        // Serialize all form fields so every tab change is reflected live.
        var $form = $('#wcef-settings-form');
        if ($form.length) {
            base += '&' + $form.serialize();
        }

        return base;
    }

    function loadPreview() {
        var $container = $('#wcef-preview-container');
        var $iframe = $('#wcef-preview-iframe');
        var $loading = $('#wcef-preview-loading');

        if (!$container.length) return;

        $loading.removeClass('hidden');

        var url = buildPreviewUrl();

        // When iframe loads the PDF, hide the spinner.
        $iframe.off('load.wcef').on('load.wcef', function() {
            $loading.addClass('hidden');
        });

        $iframe.attr('src', url);
    }

    function schedulePreview() {
        clearTimeout(previewTimer);
        previewTimer = setTimeout(loadPreview, 500);
    }

    // Listen to ALL form controls on settings page.
    $(function() {
        if (!$('#wcef-preview-container').length) return;

        // Initial load.
        loadPreview();

        // Range slider value display.
        $(document.body).on('input', '#wcef_design_logo_max_height', function() {
            $('#wcef-logo-size-value').text(this.value + 'mm');
        });

        // Any input/select/textarea change inside the settings form triggers preview.
        $(document.body).on('change input', '#wcef-settings-form input, #wcef-settings-form select', function() {
            schedulePreview();
        });
        $(document.body).on('keyup', '#wcef-settings-form textarea', function() {
            schedulePreview();
        });

        // Manual refresh button.
        $(document.body).on('click', '#wcef-refresh-preview', function(e) {
            e.preventDefault();
            loadPreview();
        });
    });

    /* ---- Settings: Dynamic recommendations on legal form change ---- */

    function getRecommendations(form) {
        var recs = {};
        if (form === 'AE' || form === 'EI') {
            recs.vat_regime_tip = 'Les auto-entrepreneurs et EI sont generalement en franchise en base de TVA (sauf depassement de seuils).';
            recs.rcs_tip = 'Pas de RCS requis pour les EI/auto-entrepreneurs (sauf si commer\u00e7ant inscrit au RCS).';
            recs.capital_tip = 'Pas de capital social pour les EI/auto-entrepreneurs.';
        } else if (form === 'SAS' || form === 'SASU' || form === 'SARL' || form === 'EURL' || form === 'SA' || form === 'SNC') {
            recs.vat_regime_tip = 'Les societes commerciales sont generalement soumises a la TVA au taux normal.';
            recs.rcs_tip = 'Obligatoire \u2014 indiquez la ville de votre tribunal de commerce (ex: RCS Paris).';
            recs.capital_tip = 'Obligatoire \u2014 indiquez le montant (ex: 10 000 EUR).';
        } else if (form === 'SCI') {
            recs.vat_regime_tip = 'Les SCI sont generalement exonerees de TVA sur les locations nues.';
            recs.rcs_tip = 'Obligatoire si la SCI est immatriculee au RCS.';
        }
        return recs;
    }

    function updateFieldRec(id, tip) {
        var $existing = $('#' + id);
        if (!tip) {
            $existing.slideUp(150, function() { $(this).remove(); });
            return;
        }
        var html = '<span class="wcef-field-rec-icon">&#9432;</span><span class="wcef-field-rec-text">' + $('<span>').text(tip).html() + '</span>';
        if ($existing.length) {
            $existing.html(html);
        } else {
            var $el;
            if (id === 'wcef-rec-rcs') {
                $el = $('<div class="wcef-field-rec" id="' + id + '">' + html + '</div>').hide();
                $('#wcef_rcs').closest('.wcef-field').append($el);
                $el.slideDown(150);
            } else if (id === 'wcef-rec-capital') {
                $el = $('<div class="wcef-field-rec" id="' + id + '">' + html + '</div>').hide();
                $('#wcef_capital').closest('.wcef-field').append($el);
                $el.slideDown(150);
            }
        }
    }

    $(document.body).on('change', '#wcef_legal_form', function() {
        var form = $(this).val();
        var recs = getRecommendations(form);

        // Update per-field inline tooltips (RCS, Capital).
        updateFieldRec('wcef-rec-rcs', recs.rcs_tip || '');
        updateFieldRec('wcef-rec-capital', recs.capital_tip || '');

        // Update the summary banner.
        var $banner = $('#wcef-recommendations');
        if (!Object.keys(recs).length) {
            $banner.slideUp(200);
            return;
        }

        var formLabel = $('#wcef_legal_form option:selected').text();

        var html = '<div class="wcef-rec-icon">&#9432;</div>';
        html += '<div class="wcef-rec-content">';
        html += '<strong>Recommandations pour \u00AB ' + $('<span>').text(formLabel).html() + ' \u00BB</strong>';
        html += '<ul>';
        if (recs.vat_regime_tip) html += '<li>' + $('<span>').text(recs.vat_regime_tip).html() + '</li>';
        if (recs.rcs_tip) html += '<li>' + $('<span>').text(recs.rcs_tip).html() + '</li>';
        if (recs.capital_tip) html += '<li>' + $('<span>').text(recs.capital_tip).html() + '</li>';
        html += '</ul></div>';

        if ($banner.length) {
            $banner.html(html).slideDown(200);
        } else {
            var $bannerEl = $('<div class="wcef-recommendation-banner" id="wcef-recommendations">' + html + '</div>').hide();
            $('#wcef_legal_form').closest('.wcef-field-row').after($bannerEl);
            $bannerEl.slideDown(200);
        }
    });

    /* ============================================
       CHORUS PRO: Transmit Invoice
       ============================================ */

    $(document.body).on('click', '.wcef-btn-transmit', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var invoiceId = $btn.data('invoice-id');
        if (!invoiceId || $btn.prop('disabled')) return;

        if (!confirm('Transmettre cette facture a Chorus Pro ?')) return;

        $btn.prop('disabled', true).text('Envoi...');

        $.post(wcef.ajax_url, {
            action: 'wcef_transmit_invoice',
            nonce: wcef.nonce,
            invoice_id: invoiceId
        }, function(response) {
            if (response.success) {
                $btn.text('Transmise').addClass('button-disabled');
                location.reload();
            } else {
                $btn.prop('disabled', false).text('Transmettre PA');
                alert('Erreur : ' + (response.data || 'Erreur inconnue'));
            }
        }).fail(function() {
            $btn.prop('disabled', false).text('Transmettre PA');
            alert('Erreur de connexion.');
        });
    });

    /* ============================================
       CHORUS PRO: Test Connection
       ============================================ */

    $(document.body).on('click', '#wcef-test-chorus', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var $result = $('#wcef-chorus-test-result');
        $btn.prop('disabled', true).text('Test en cours...');
        $result.html('');

        $.post(wcef.ajax_url, {
            action: 'wcef_test_chorus',
            nonce: wcef.nonce
        }, function(response) {
            $btn.prop('disabled', false).text('Tester la connexion');
            if (response.success) {
                $result.html('<span style="color:var(--wcef-green);font-weight:600">Connexion reussie !</span>');
            } else {
                $result.html('<span style="color:var(--wcef-red)">' + (response.data || 'Echec de connexion.') + '</span>');
            }
        }).fail(function() {
            $btn.prop('disabled', false).text('Tester la connexion');
            $result.html('<span style="color:var(--wcef-red)">Erreur de connexion.</span>');
        });
    });

    /* ============================================
       CHORUS PRO: Refresh Invoice Status
       ============================================ */

    $(document.body).on('click', '.wcef-btn-refresh-status', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var invoiceId = $btn.data('invoice-id');
        if (!invoiceId || $btn.prop('disabled')) return;

        $btn.prop('disabled', true).text('Verification...');

        $.post(wcef.ajax_url, {
            action: 'wcef_check_invoice_status',
            nonce: wcef.nonce,
            invoice_id: invoiceId
        }, function(response) {
            if (response.success) {
                location.reload();
            } else {
                $btn.prop('disabled', false).text('Rafraichir statut');
                alert('Erreur : ' + (response.data || 'Erreur inconnue'));
            }
        }).fail(function() {
            $btn.prop('disabled', false).text('Rafraichir statut');
            alert('Erreur de connexion.');
        });
    });

    /* ============================================
       BULK TRANSMIT
       ============================================ */

    $(document.body).on('click', '#doaction, #doaction2', function(e) {
        var action = $(this).prev('select').val();
        if (action !== 'transmit_pa') return;

        e.preventDefault();

        var ids = [];
        $('input[name="supplier_invoice[]"]:checked, input[name="invoice[]"]:checked').each(function() {
            ids.push($(this).val());
        });

        if (!ids.length) {
            alert('Selectionnez au moins une facture.');
            return;
        }

        if (!confirm('Transmettre ' + ids.length + ' facture(s) a Chorus Pro ?')) return;

        // Show overlay.
        var $overlay = $('<div class="wcef-bulk-overlay"><div class="wcef-bulk-progress"><h3>Transmission en cours...</h3><div class="wcef-progress-bar"><div class="wcef-progress-fill" style="width:0%"></div></div><p class="wcef-bulk-status">0 / ' + ids.length + '</p></div></div>');
        $('body').append($overlay);

        $.post(wcef.ajax_url, {
            action: 'wcef_bulk_transmit',
            nonce: wcef.nonce,
            invoice_ids: ids
        }, function(response) {
            $overlay.remove();
            if (response.success) {
                var msg = response.data.success + ' transmise(s)';
                if (response.data.errors > 0) {
                    msg += ', ' + response.data.errors + ' erreur(s)';
                }
                alert(msg);
                location.reload();
            } else {
                alert('Erreur : ' + (response.data || 'Erreur inconnue'));
            }
        }).fail(function() {
            $overlay.remove();
            alert('Erreur de connexion.');
        });
    });

    /* ============================================
       SUPPLIERS: Sync with Chorus Pro
       ============================================ */

    $(document.body).on('click', '#wcef-sync-suppliers', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var $status = $('#wcef-sync-status');

        $btn.prop('disabled', true).text('Synchronisation...');
        $status.show().text('En cours...');

        $.post(wcef.ajax_url, {
            action: 'wcef_fetch_supplier_invoices',
            nonce: wcef.nonce
        }, function(response) {
            $btn.prop('disabled', false).text('Synchroniser avec Chorus Pro');
            if (response.success) {
                $status.html('<span style="color:var(--wcef-green)">' + response.data.message + '</span>');
                if (response.data.synced > 0) {
                    setTimeout(function() { location.reload(); }, 1500);
                }
            } else {
                $status.html('<span style="color:var(--wcef-red)">' + (response.data || 'Erreur de synchronisation.') + '</span>');
            }
        }).fail(function() {
            $btn.prop('disabled', false).text('Synchroniser avec Chorus Pro');
            $status.html('<span style="color:var(--wcef-red)">Erreur de connexion.</span>');
        });
    });

    /* ============================================
       API KEY: Generate
       ============================================ */

    $(document.body).on('click', '#wcef-generate-api-key', function(e) {
        e.preventDefault();
        var $btn = $(this);
        if (!confirm('Generer une nouvelle cle API ? L\'ancienne sera remplacee.')) return;

        $btn.prop('disabled', true).text('Generation...');

        $.post(wcef.ajax_url, {
            action: 'wcef_generate_api_key',
            nonce: wcef.nonce
        }, function(response) {
            $btn.prop('disabled', false).text('Generer');
            if (response.success) {
                $('#wcef_api_key_display').val(response.data.api_key);
            } else {
                alert('Erreur : ' + (response.data || 'Erreur inconnue'));
            }
        }).fail(function() {
            $btn.prop('disabled', false).text('Generer');
            alert('Erreur de connexion.');
        });
    });

})(jQuery);
