<?php
defined( 'ABSPATH' ) || exit;

/**
 * Invoice export functionality — CSV generation.
 */
class WCEF_Export {

	/**
	 * Generate CSV content from invoices.
	 */
	public static function generate_csv( array $args = array() ): string {
		$result = WCEF_Invoice::list( array_merge( $args, array( 'per_page' => 10000, 'offset' => 0 ) ) );
		$output = fopen( 'php://temp', 'r+' );

		// BOM for Excel UTF-8 compatibility.
		fwrite( $output, "\xEF\xBB\xBF" );

		// Header row.
		fputcsv( $output, array(
			'Numero facture',
			'Commande',
			'Client',
			'SIREN',
			'TVA Intra',
			'Total HT',
			'Total TVA',
			'Total TTC',
			'Statut',
			'Date',
			'Transmise le',
		), ';' );

		foreach ( $result['items'] as $item ) {
			$order = wc_get_order( $item->order_id );
			$buyer = '';
			if ( $order ) {
				$buyer = $order->get_billing_company() ?: ( $order->get_billing_first_name() . ' ' . $order->get_billing_last_name() );
			}

			fputcsv( $output, array(
				$item->invoice_number,
				'#' . $item->order_id,
				$buyer,
				$item->buyer_siren,
				$item->buyer_tva,
				number_format( (float) $item->total_ht, 2, '.', '' ),
				number_format( (float) $item->total_tax, 2, '.', '' ),
				number_format( (float) $item->total_ttc, 2, '.', '' ),
				$item->status,
				$item->created_at,
				$item->transmitted_at ?? '',
			), ';' );
		}

		rewind( $output );
		$csv = stream_get_contents( $output );
		fclose( $output );
		return $csv;
	}
}
