<?php
defined( 'ABSPATH' ) || exit;
?>
<div class="wrap wcef-invoices-wrap">
	<div class="wcef-page-header">
		<h1>
			<?php esc_html_e( 'E-Facturation', 'wc-efacturation-france' ); ?>
			<span class="wcef-version">v<?php echo esc_html( WCEF_VERSION ); ?></span>
		</h1>
	</div>

	<?php
	// Upgrade banner — context-aware based on licence plan + routing.
	$current_plan    = WCEF_License::get_plan();
	$current_routing = WCEF_License::get_routing();
	$dismissed       = get_user_meta( get_current_user_id(), 'wcef_banner_dismissed', true );

	$show_banner = false;
	if ( ! $dismissed ) :
		if ( 'starter' === $current_plan || ( 'core' === $current_plan && 'none' === $current_routing ) ) :
			$banner_title    = 'Passez au plan Essentiel';
			$banner_text     = 'Transmettez vos factures vers votre Plateforme Agreee, suivez les statuts en temps reel et recevez les factures fournisseurs.';
			$banner_features = array( 'Routage PA automatique', 'Statuts temps reel', 'Reception fournisseurs', 'Exports CSV + API' );
			$show_banner     = true;
		endif;

		if ( $show_banner ) :
		?>
		<div class="wcef-upgrade-banner">
			<div class="banner-content">
				<h3><?php echo esc_html( $banner_title ); ?></h3>
				<p><?php echo esc_html( $banner_text ); ?></p>
				<div class="banner-features">
					<?php foreach ( $banner_features as $feat ) : ?>
						<span><?php echo esc_html( $feat ); ?></span>
					<?php endforeach; ?>
				</div>
			</div>
			<a href="https://efacturx.com/#tarifs" class="banner-btn" target="_blank" rel="noopener">
				<?php esc_html_e( 'Voir les offres', 'wc-efacturation-france' ); ?> &rarr;
			</a>
			<button type="button" class="wcef-dismiss-banner" aria-label="<?php esc_attr_e( 'Fermer', 'wc-efacturation-france' ); ?>">&times;</button>
		</div>
		<?php endif; ?>
	<?php endif; ?>

	<div class="wcef-stats">
		<?php
		global $wpdb;
		$table       = $wpdb->prefix . 'wcef_invoices';
		$total_count = (int) $wpdb->get_var( "SELECT COUNT(*) FROM {$table}" ); // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
		$month_start = gmdate( 'Y-m-01 00:00:00' );
		$month_count = (int) $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM {$table} WHERE created_at >= %s", $month_start ) ); // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
		$month_total = (float) $wpdb->get_var( $wpdb->prepare( "SELECT COALESCE(SUM(total_ttc), 0) FROM {$table} WHERE created_at >= %s", $month_start ) ); // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
		$month_ht    = (float) $wpdb->get_var( $wpdb->prepare( "SELECT COALESCE(SUM(total_ht), 0) FROM {$table} WHERE created_at >= %s", $month_start ) ); // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
		?>
		<div class="wcef-stat-card">
			<div class="stat-label"><?php esc_html_e( 'Total factures', 'wc-efacturation-france' ); ?></div>
			<div class="stat-value"><?php echo esc_html( $total_count ); ?></div>
			<div class="stat-sub"><?php esc_html_e( 'depuis l\'activation', 'wc-efacturation-france' ); ?></div>
		</div>
		<div class="wcef-stat-card">
			<div class="stat-label"><?php esc_html_e( 'Ce mois', 'wc-efacturation-france' ); ?></div>
			<div class="stat-value"><?php echo esc_html( $month_count ); ?></div>
			<div class="stat-sub"><?php echo esc_html( wp_date( 'F Y' ) ); ?></div>
		</div>
		<div class="wcef-stat-card">
			<div class="stat-label"><?php esc_html_e( 'CA HT ce mois', 'wc-efacturation-france' ); ?></div>
			<div class="stat-value"><?php echo esc_html( number_format( $month_ht, 2, ',', ' ' ) ); ?> &euro;</div>
			<div class="stat-sub"><?php esc_html_e( 'hors taxes', 'wc-efacturation-france' ); ?></div>
		</div>
		<div class="wcef-stat-card">
			<div class="stat-label"><?php esc_html_e( 'CA TTC ce mois', 'wc-efacturation-france' ); ?></div>
			<div class="stat-value"><?php echo esc_html( number_format( $month_total, 2, ',', ' ' ) ); ?> &euro;</div>
			<div class="stat-sub"><?php esc_html_e( 'toutes taxes comprises', 'wc-efacturation-france' ); ?></div>
		</div>
		<?php if ( WCEF_License::can( 'routage_pa' ) ) :
			$usage = WCEF_Transmission_Counter::get_usage_data();
		?>
		<div class="wcef-stat-card">
			<div class="stat-label"><?php esc_html_e( 'Transmissions ce mois', 'wc-efacturation-france' ); ?></div>
			<div class="stat-value"><?php echo esc_html( $usage['count'] ); ?><?php echo $usage['limit'] > 0 ? ' / ' . esc_html( $usage['limit'] ) : ''; ?></div>
			<div class="stat-sub">
				<?php if ( $usage['limit'] < 0 ) : ?>
					<?php esc_html_e( 'illimite', 'wc-efacturation-france' ); ?>
				<?php elseif ( $usage['remaining'] > 0 ) : ?>
					<?php echo esc_html( $usage['remaining'] ); ?> <?php esc_html_e( 'restantes', 'wc-efacturation-france' ); ?>
				<?php else : ?>
					<span style="color: var(--wcef-red);"><?php esc_html_e( 'Limite atteinte', 'wc-efacturation-france' ); ?></span>
				<?php endif; ?>
			</div>
			<?php if ( $usage['limit'] > 0 ) : ?>
			<div class="wcef-progress-bar" style="margin-top: 8px;">
				<div class="wcef-progress-fill<?php echo $usage['percentage'] >= 90 ? ' wcef-progress-warning' : ''; ?>" style="width: <?php echo esc_attr( $usage['percentage'] ); ?>%;"></div>
			</div>
			<?php endif; ?>
		</div>
		<?php endif; ?>
	</div>

	<?php if ( WCEF_License::can( 'export_comptable' ) ) : ?>
	<div class="wcef-export-actions" style="margin-bottom: 16px;">
		<?php
		$csv_url = wp_nonce_url(
			admin_url( 'admin-ajax.php?action=wcef_export_csv' ),
			'wcef_nonce',
			'nonce'
		);
		?>
		<a href="<?php echo esc_url( $csv_url ); ?>" class="button">
			<?php esc_html_e( 'Exporter CSV', 'wc-efacturation-france' ); ?>
		</a>
	</div>
	<?php endif; ?>

	<form method="get">
		<input type="hidden" name="page" value="wcef-invoices">
		<?php
		$list_table->search_box( __( 'Rechercher', 'wc-efacturation-france' ), 'wcef-search' );
		$list_table->display();
		?>
	</form>
</div>
