<?php
defined( 'ABSPATH' ) || exit;

/**
 * @var WC_Order $order
 * @var object|null $invoice
 */
?>
<div class="wcef-meta-box">
	<?php if ( $invoice ) : ?>
		<div class="wcef-meta-row">
			<span class="wcef-meta-label"><?php esc_html_e( 'Facture', 'wc-efacturation-france' ); ?></span>
			<span class="wcef-meta-value"><?php echo esc_html( $invoice->invoice_number ); ?></span>
		</div>
		<div class="wcef-meta-row">
			<span class="wcef-meta-label"><?php esc_html_e( 'Statut', 'wc-efacturation-france' ); ?></span>
			<span class="wcef-meta-value">
				<?php
				$status_labels = WCEF_Invoice::get_status_labels();
				$badge_class   = 'wcef-badge-' . esc_attr( $invoice->status );
				$label         = $status_labels[ $invoice->status ] ?? $invoice->status;
				?>
				<span class="wcef-badge <?php echo esc_attr( $badge_class ); ?>">
					<?php echo esc_html( $label ); ?>
				</span>
			</span>
		</div>
		<div class="wcef-meta-row">
			<span class="wcef-meta-label"><?php esc_html_e( 'Date', 'wc-efacturation-france' ); ?></span>
			<span class="wcef-meta-value"><?php echo esc_html( date_i18n( 'd/m/Y H:i', strtotime( $invoice->created_at ) ) ); ?></span>
		</div>
		<div class="wcef-meta-row">
			<span class="wcef-meta-label"><?php esc_html_e( 'Total TTC', 'wc-efacturation-france' ); ?></span>
			<span class="wcef-meta-value"><?php echo esc_html( number_format( (float) $invoice->total_ttc, 2, ',', ' ' ) ); ?> &euro;</span>
		</div>

		<?php if ( ! empty( $invoice->transmitted_at ) ) : ?>
		<div class="wcef-meta-row">
			<span class="wcef-meta-label"><?php esc_html_e( 'Transmise le', 'wc-efacturation-france' ); ?></span>
			<span class="wcef-meta-value"><?php echo esc_html( date_i18n( 'd/m/Y H:i', strtotime( $invoice->transmitted_at ) ) ); ?></span>
		</div>
		<?php endif; ?>

		<?php if ( ! empty( $invoice->transmission_error ) ) : ?>
			<div class="wcef-meta-row">
				<span class="wcef-meta-label" style="color: var(--wcef-red);"><?php esc_html_e( 'Erreur', 'wc-efacturation-france' ); ?></span>
				<span class="wcef-meta-value" style="color: var(--wcef-red); font-size: 12px;"><?php echo esc_html( $invoice->transmission_error ); ?></span>
			</div>
		<?php elseif ( ! empty( $invoice->error_message ) ) : ?>
			<div class="wcef-meta-row">
				<span class="wcef-meta-label" style="color: var(--wcef-red);"><?php esc_html_e( 'Erreur', 'wc-efacturation-france' ); ?></span>
				<span class="wcef-meta-value" style="color: var(--wcef-red); font-size: 12px;"><?php echo esc_html( $invoice->error_message ); ?></span>
			</div>
		<?php endif; ?>

		<div class="wcef-meta-actions">
			<?php
			$pdf_url = wp_nonce_url(
				admin_url( 'admin-ajax.php?action=wcef_download_pdf&invoice_id=' . absint( $invoice->id ) ),
				'wcef_nonce',
				'nonce'
			);
			$xml_url = wp_nonce_url(
				admin_url( 'admin-ajax.php?action=wcef_download_xml&invoice_id=' . absint( $invoice->id ) ),
				'wcef_nonce',
				'nonce'
			);
			?>
			<a href="<?php echo esc_url( $pdf_url ); ?>" class="button button-small wcef-btn-pdf" target="_blank">
				<?php esc_html_e( 'PDF', 'wc-efacturation-france' ); ?>
			</a>
			<a href="<?php echo esc_url( $xml_url ); ?>" class="button button-small wcef-btn-xml">
				<?php esc_html_e( 'XML', 'wc-efacturation-france' ); ?>
			</a>

			<?php if ( WCEF_License::can( 'routage_pa' ) && 'generated' === $invoice->status ) : ?>
				<button type="button" class="button button-small wcef-btn-transmit" data-invoice-id="<?php echo esc_attr( $invoice->id ); ?>">
					<?php esc_html_e( 'Transmettre PA', 'wc-efacturation-france' ); ?>
				</button>
			<?php endif; ?>

			<?php if ( WCEF_License::can( 'statuts_temps_reel' ) && ! empty( $invoice->chorus_id ) && in_array( $invoice->status, array( 'transmitted', 'pending_transmission' ), true ) ) : ?>
				<button type="button" class="button button-small wcef-btn-refresh-status" data-invoice-id="<?php echo esc_attr( $invoice->id ); ?>">
					<?php esc_html_e( 'Rafraichir statut', 'wc-efacturation-france' ); ?>
				</button>
			<?php endif; ?>
		</div>

		<?php
		// Status timeline.
		if ( WCEF_License::can( 'statuts_temps_reel' ) && ! empty( $invoice->chorus_id ) ) :
			$timeline = WCEF_Invoice::get_status_timeline( $invoice->id );
			if ( ! empty( $timeline ) ) :
			?>
			<div class="wcef-status-timeline" style="margin-top: 16px; padding-top: 12px; border-top: 1px solid #e0e0e0;">
				<strong style="font-size: 12px; text-transform: uppercase; color: #666; display: block; margin-bottom: 8px;"><?php esc_html_e( 'Historique', 'wc-efacturation-france' ); ?></strong>
				<?php foreach ( $timeline as $entry ) : ?>
					<div class="wcef-timeline-entry" style="display: flex; gap: 8px; margin-bottom: 6px; font-size: 12px;">
						<span class="wcef-timeline-dot" style="flex-shrink: 0; width: 8px; height: 8px; border-radius: 50%; background: var(--wcef-primary); margin-top: 4px;"></span>
						<div class="wcef-timeline-content">
							<span style="color: #666;"><?php echo esc_html( date_i18n( 'd/m H:i', strtotime( $entry->created_at ) ) ); ?></span>
							<span class="wcef-badge wcef-badge-<?php echo esc_attr( $entry->status ); ?>" style="font-size: 10px; padding: 1px 6px;">
								<?php echo esc_html( $status_labels[ $entry->status ] ?? $entry->status ); ?>
							</span>
							<?php if ( ! empty( $entry->message ) ) : ?>
								<span style="color: #444;"><?php echo esc_html( $entry->message ); ?></span>
							<?php endif; ?>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
			<?php endif; ?>
		<?php endif; ?>

	<?php else : ?>
		<div class="wcef-empty">
			<p><?php esc_html_e( 'Aucune facture generee pour cette commande.', 'wc-efacturation-france' ); ?></p>
			<button type="button" class="wcef-generate-btn" data-order-id="<?php echo esc_attr( $order->get_id() ); ?>">
				<?php esc_html_e( 'Generer la facture', 'wc-efacturation-france' ); ?>
			</button>
		</div>
	<?php endif; ?>
</div>
