<?php
defined( 'ABSPATH' ) || exit;

$active_tab      = sanitize_text_field( wp_unslash( $_GET['tab'] ?? 'entreprise' ) ); // phpcs:ignore WordPress.Security.NonceVerification
$legal_form      = get_option( 'wcef_legal_form', '' );
$recommendations = WCEF_Settings::get_recommendations( $legal_form );
$logo_id         = absint( get_option( 'wcef_logo_id', 0 ) );
$logo_url        = $logo_id ? wp_get_attachment_image_url( $logo_id, 'thumbnail' ) : '';
$license_data    = WCEF_License::verify();
$license_plan    = $license_data['plan'];
$license_routing = $license_data['routing'] ?? 'none';
$license_key     = get_option( 'wcef_license_key', '' );
$plan_labels     = WCEF_License::get_plan_labels();

$tabs = array(
	'entreprise'  => 'Entreprise',
	'facturation' => 'Facturation',
	'legal'       => 'Mentions legales',
	'design'      => 'Design facture',
	'chorus'      => 'Chorus Pro',
	'support'     => 'Support',
);
?>
<div class="wrap wcef-settings-wrap wcef-settings-with-preview">
	<div class="wcef-settings-header">
		<h1>
			<svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" style="vertical-align: -4px; margin-right: 6px; color: var(--wcef-primary);"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/><polyline points="14 2 14 8 20 8"/><line x1="8" y1="13" x2="16" y2="13"/><line x1="8" y1="17" x2="13" y2="17"/></svg>
			<?php esc_html_e( 'Reglages E-Facturation', 'wc-efacturation-france' ); ?>
			<span class="wcef-version">v<?php echo esc_html( WCEF_VERSION ); ?></span>
		</h1>
	</div>

	<nav class="wcef-tabs">
		<?php foreach ( $tabs as $slug => $label ) : ?>
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=wcef-settings&tab=' . $slug ) ); ?>"
			   class="wcef-tab <?php echo $active_tab === $slug ? 'active' : ''; ?>">
				<?php echo esc_html( $label ); ?>
			</a>
		<?php endforeach; ?>
	</nav>

	<div class="wcef-settings-layout">
		<div class="wcef-settings-controls">
			<form id="wcef-settings-form" method="post">
				<?php wp_nonce_field( 'wcef_nonce', '_wcef_nonce' ); ?>
				<input type="hidden" name="wcef_active_tab" value="<?php echo esc_attr( $active_tab ); ?>">

				<?php if ( 'entreprise' === $active_tab ) : ?>
				<!-- ═══ LICENCE ═══ -->
				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Licence e-facturX</h2>
						<p>Activez votre licence pour debloquer toutes les fonctionnalites.</p>
					</div>
					<div class="wcef-card-body">
						<div class="wcef-license-status">
							<span class="wcef-plan-badge wcef-plan-<?php echo esc_attr( $license_plan ); ?>">
								<?php echo esc_html( WCEF_License::get_full_plan_label() ); ?>
							</span>
							<?php if ( ! empty( $license_data['expires'] ) ) : ?>
								<span class="wcef-license-expires">Expire le <?php echo esc_html( wp_date( 'j F Y', strtotime( $license_data['expires'] ) ) ); ?></span>
							<?php endif; ?>
						</div>

						<div class="wcef-field-row" style="margin-top: 16px;">
							<div class="wcef-field wcef-field-wide">
								<label for="wcef_license_key">Cle de licence</label>
								<div style="display: flex; gap: 8px; align-items: start;">
									<input type="text" id="wcef_license_key" value="<?php echo esc_attr( $license_key ); ?>" placeholder="WCEF-XXXX-XXXX-XXXX" style="flex: 1;">
									<?php if ( empty( $license_key ) || 'starter' === $license_plan ) : ?>
										<button type="button" class="button button-primary" id="wcef-activate-license">Activer</button>
									<?php else : ?>
										<button type="button" class="button" id="wcef-activate-license">Verifier</button>
										<button type="button" class="button" id="wcef-deactivate-license" style="color: var(--wcef-red);">Desactiver</button>
									<?php endif; ?>
								</div>
								<p class="wcef-field-desc" id="wcef-license-msg">
									<?php if ( 'starter' === $license_plan ) : ?>
										Pas de licence ? <a href="https://efacturx.com/#tarifs" target="_blank" style="color: var(--wcef-primary); font-weight: 600;">Voir les offres</a>
									<?php else : ?>
										Licence active — <?php echo esc_html( WCEF_License::get_full_plan_label() ); ?>
									<?php endif; ?>
								</p>
							</div>
						</div>
					</div>
				</div>

				<!-- ═══ TAB: ENTREPRISE ═══ -->
				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Identification de l'entreprise</h2>
						<p>Ces informations apparaissent sur vos factures et dans les donnees XML Factur-X.</p>
					</div>
					<div class="wcef-card-body">
						<div class="wcef-field-row">
							<div class="wcef-field wcef-field-wide">
								<label for="wcef_company_name">Raison sociale <span class="required">*</span></label>
								<input type="text" id="wcef_company_name" name="wcef_company_name" value="<?php echo esc_attr( get_option( 'wcef_company_name', get_bloginfo( 'name' ) ) ); ?>" class="regular-text">
							</div>
						</div>

						<div class="wcef-field-row">
							<div class="wcef-field">
								<label for="wcef_legal_form">Forme juridique <span class="required">*</span></label>
								<select id="wcef_legal_form" name="wcef_legal_form">
									<?php foreach ( WCEF_Settings::get_legal_forms() as $val => $label ) : ?>
										<option value="<?php echo esc_attr( $val ); ?>" <?php selected( $legal_form, $val ); ?>><?php echo esc_html( $label ); ?></option>
									<?php endforeach; ?>
								</select>
								<p class="wcef-field-tip" id="wcef-legal-form-tip">La forme juridique determine les mentions obligatoires sur vos factures.</p>
							</div>
						</div>

						<?php if ( ! empty( $recommendations ) ) : ?>
						<div class="wcef-recommendation-banner" id="wcef-recommendations">
							<div class="wcef-rec-icon">&#9432;</div>
							<div class="wcef-rec-content">
								<strong>Recommandations pour « <?php echo esc_html( WCEF_Settings::get_legal_forms()[ $legal_form ] ?? $legal_form ); ?> »</strong>
								<ul>
									<?php if ( ! empty( $recommendations['vat_regime_tip'] ) ) : ?>
										<li><?php echo esc_html( $recommendations['vat_regime_tip'] ); ?></li>
									<?php endif; ?>
									<?php if ( ! empty( $recommendations['rcs_tip'] ) ) : ?>
										<li><?php echo esc_html( $recommendations['rcs_tip'] ); ?></li>
									<?php endif; ?>
									<?php if ( ! empty( $recommendations['capital_tip'] ) ) : ?>
										<li><?php echo esc_html( $recommendations['capital_tip'] ); ?></li>
									<?php endif; ?>
								</ul>
							</div>
						</div>
						<?php endif; ?>

						<div class="wcef-field-row wcef-field-row-3">
							<div class="wcef-field">
								<label for="wcef_siren">SIREN <span class="required">*</span></label>
								<input type="text" id="wcef_siren" name="wcef_siren" value="<?php echo esc_attr( get_option( 'wcef_siren', '' ) ); ?>" maxlength="9" placeholder="123456789">
								<p class="wcef-field-desc">9 chiffres</p>
							</div>
							<div class="wcef-field">
								<label for="wcef_siret">SIRET</label>
								<input type="text" id="wcef_siret" name="wcef_siret" value="<?php echo esc_attr( get_option( 'wcef_siret', '' ) ); ?>" maxlength="14" placeholder="12345678901234">
								<p class="wcef-field-desc">14 chiffres (SIREN + NIC)</p>
							</div>
							<div class="wcef-field">
								<label for="wcef_tva_intra">N&deg; TVA intracommunautaire</label>
								<input type="text" id="wcef_tva_intra" name="wcef_tva_intra" value="<?php echo esc_attr( get_option( 'wcef_tva_intra', '' ) ); ?>" placeholder="FR12345678901">
								<p class="wcef-field-desc">Format : FR + 11 chiffres</p>
							</div>
						</div>

						<div class="wcef-field-row wcef-field-row-2">
							<div class="wcef-field">
								<label for="wcef_rcs">RCS (ville)</label>
								<input type="text" id="wcef_rcs" name="wcef_rcs" value="<?php echo esc_attr( get_option( 'wcef_rcs', '' ) ); ?>" placeholder="RCS Paris">
								<p class="wcef-field-desc">Obligatoire pour les societes commerciales</p>
								<?php if ( ! empty( $recommendations['rcs_tip'] ) ) : ?>
								<div class="wcef-field-rec" id="wcef-rec-rcs">
									<span class="wcef-field-rec-icon">&#9432;</span>
									<span class="wcef-field-rec-text"><?php echo esc_html( $recommendations['rcs_tip'] ); ?></span>
								</div>
								<?php endif; ?>
							</div>
							<div class="wcef-field">
								<label for="wcef_capital">Capital social</label>
								<input type="text" id="wcef_capital" name="wcef_capital" value="<?php echo esc_attr( get_option( 'wcef_capital', '' ) ); ?>" placeholder="10 000 EUR">
								<?php if ( ! empty( $recommendations['capital_tip'] ) ) : ?>
								<div class="wcef-field-rec" id="wcef-rec-capital">
									<span class="wcef-field-rec-icon">&#9432;</span>
									<span class="wcef-field-rec-text"><?php echo esc_html( $recommendations['capital_tip'] ); ?></span>
								</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>

				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Adresse du siege</h2>
					</div>
					<div class="wcef-card-body">
						<div class="wcef-field-row">
							<div class="wcef-field wcef-field-wide">
								<label for="wcef_address">Adresse</label>
								<textarea id="wcef_address" name="wcef_address" rows="2"><?php echo esc_textarea( get_option( 'wcef_address', '' ) ); ?></textarea>
							</div>
						</div>
						<div class="wcef-field-row wcef-field-row-2">
							<div class="wcef-field">
								<label for="wcef_postcode">Code postal</label>
								<input type="text" id="wcef_postcode" name="wcef_postcode" value="<?php echo esc_attr( get_option( 'wcef_postcode', '' ) ); ?>" maxlength="5" style="width:120px;">
							</div>
							<div class="wcef-field">
								<label for="wcef_city">Ville</label>
								<input type="text" id="wcef_city" name="wcef_city" value="<?php echo esc_attr( get_option( 'wcef_city', '' ) ); ?>">
							</div>
						</div>
					</div>
				</div>

				<?php elseif ( 'facturation' === $active_tab ) : ?>
				<!-- ═══ TAB: FACTURATION ═══ -->
				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Parametres de facturation</h2>
						<p>Configurez la numerotation et le format de vos factures.</p>
					</div>
					<div class="wcef-card-body">
						<div class="wcef-field-row wcef-field-row-2">
							<div class="wcef-field">
								<label for="wcef_invoice_prefix">Prefixe numero de facture</label>
								<input type="text" id="wcef_invoice_prefix" name="wcef_invoice_prefix" value="<?php echo esc_attr( get_option( 'wcef_invoice_prefix', 'FA-' ) ); ?>" style="width:120px;">
								<p class="wcef-field-desc">Ex : FA-, F-2026-, INV-</p>
							</div>
							<div class="wcef-field">
								<label for="wcef_next_invoice_number">Prochain numero</label>
								<input type="number" id="wcef_next_invoice_number" name="wcef_next_invoice_number" value="<?php echo esc_attr( get_option( 'wcef_next_invoice_number', '1' ) ); ?>" min="1" style="width:120px;">
								<p class="wcef-field-desc">La numerotation doit etre sequentielle et sans trou (obligation legale).</p>
							</div>
						</div>

						<div class="wcef-field-row">
							<div class="wcef-field">
								<label for="wcef_invoice_format">Format de facture</label>
								<select id="wcef_invoice_format" name="wcef_invoice_format">
									<?php foreach ( WCEF_Settings::get_formats() as $val => $label ) : ?>
										<option value="<?php echo esc_attr( $val ); ?>" <?php selected( get_option( 'wcef_invoice_format', 'facturx' ), $val ); ?>><?php echo esc_html( $label ); ?></option>
									<?php endforeach; ?>
								</select>
								<p class="wcef-field-desc">Factur-X est le format recommande : il combine un PDF lisible et un XML structure.</p>
							</div>
						</div>

						<div class="wcef-field-row">
							<div class="wcef-field">
								<label class="wcef-toggle-label">
									<input type="checkbox" id="wcef_auto_generate" name="wcef_auto_generate" value="yes" <?php checked( get_option( 'wcef_auto_generate', 'yes' ), 'yes' ); ?>>
									<span class="wcef-toggle-text">Generation automatique</span>
								</label>
								<p class="wcef-field-desc">Generer automatiquement la facture quand la commande passe en « Terminee » ou « En cours ».</p>
							</div>
						</div>
					</div>
				</div>

				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Pied de page facture</h2>
						<p>Coordonnees bancaires et informations complementaires affichees en bas de chaque facture.</p>
					</div>
					<div class="wcef-card-body wcef-card-body-flush">
						<table class="wcef-form-table">
							<tbody>
								<tr>
									<th scope="row">Afficher le pied de page</th>
									<td>
										<label class="wcef-toggle-label">
											<input type="checkbox" id="wcef_design_show_footer" name="wcef_design_show_footer" value="yes" <?php checked( get_option( 'wcef_design_show_footer', 'yes' ), 'yes' ); ?>>
											<span class="wcef-toggle-text">Activer</span>
										</label>
									</td>
								</tr>
								<tr>
									<th scope="row"><label for="wcef_bank_iban">IBAN</label></th>
									<td>
										<input type="text" id="wcef_bank_iban" name="wcef_bank_iban" value="<?php echo esc_attr( get_option( 'wcef_bank_iban', 'FR76 3000 4000 0500 0000 1234 567' ) ); ?>" placeholder="FR76 XXXX XXXX XXXX XXXX XXXX XXX">
									</td>
								</tr>
								<tr>
									<th scope="row"><label for="wcef_bank_bic">BIC</label></th>
									<td>
										<input type="text" id="wcef_bank_bic" name="wcef_bank_bic" value="<?php echo esc_attr( get_option( 'wcef_bank_bic', 'BNPAFRPPXXX' ) ); ?>" placeholder="BNPAFRPPXXX">
									</td>
								</tr>
								<tr>
									<th scope="row"><label for="wcef_bank_name">Banque</label></th>
									<td>
										<input type="text" id="wcef_bank_name" name="wcef_bank_name" value="<?php echo esc_attr( get_option( 'wcef_bank_name', '' ) ); ?>" placeholder="BNP Paribas">
									</td>
								</tr>
								<tr>
									<th scope="row"><label for="wcef_footer_extra">Mentions complementaires</label></th>
									<td>
										<textarea id="wcef_footer_extra" name="wcef_footer_extra" rows="2" class="large-text"><?php echo esc_textarea( get_option( 'wcef_footer_extra', '' ) ); ?></textarea>
										<p class="wcef-field-desc">Texte libre optionnel affiche sous les coordonnees bancaires. Le pied de page legal (SIREN, SIRET, TVA, etc.) est toujours inclus automatiquement.</p>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>

				<?php elseif ( 'legal' === $active_tab ) : ?>
				<!-- ═══ TAB: MENTIONS LEGALES ═══ -->
				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Regime TVA</h2>
						<p>Determine la mention TVA affichee sur les factures et dans les donnees XML.</p>
					</div>
					<div class="wcef-card-body">
						<div class="wcef-field-row">
							<div class="wcef-field wcef-field-wide">
								<label for="wcef_vat_regime">Regime TVA</label>
								<select id="wcef_vat_regime" name="wcef_vat_regime">
									<?php foreach ( WCEF_Settings::get_vat_regimes() as $val => $label ) : ?>
										<option value="<?php echo esc_attr( $val ); ?>" <?php selected( get_option( 'wcef_vat_regime', 'standard' ), $val ); ?>><?php echo esc_html( $label ); ?></option>
									<?php endforeach; ?>
								</select>
								<?php if ( ! empty( $recommendations['vat_regime_tip'] ) ) : ?>
								<div class="wcef-field-rec" id="wcef-rec-vat">
									<span class="wcef-field-rec-icon">&#9432;</span>
									<span class="wcef-field-rec-text"><?php echo esc_html( $recommendations['vat_regime_tip'] ); ?> <em>(Forme juridique : <?php echo esc_html( WCEF_Settings::get_legal_forms()[ $legal_form ] ?? $legal_form ); ?>)</em></span>
								</div>
								<?php endif; ?>
							</div>
						</div>

						<div class="wcef-vat-preview" id="wcef-vat-preview">
							<?php
							$current_regime = get_option( 'wcef_vat_regime', 'standard' );
							$previews = array(
								'standard'   => '',
								'franchise'  => 'Mention sur la facture : « TVA non applicable, art. 293 B du CGI »',
								'autoliquid' => 'Mention sur la facture : « Autoliquidation - TVA due par le preneur »',
								'intra'      => 'Mention sur la facture : « Exoneration TVA, art. 262 ter-I du CGI »',
								'export'     => 'Mention sur la facture : « Exoneration TVA, art. 262-I du CGI »',
							);
							$preview_text = $previews[ $current_regime ] ?? '';
							if ( $preview_text ) :
							?>
							<div class="wcef-vat-preview-text"><?php echo esc_html( $preview_text ); ?></div>
							<?php endif; ?>
						</div>

						<div class="wcef-field-row">
							<div class="wcef-field">
								<label class="wcef-toggle-label">
									<input type="checkbox" id="wcef_option_debits" name="wcef_option_debits" value="yes" <?php checked( get_option( 'wcef_option_debits', 'no' ), 'yes' ); ?>>
									<span class="wcef-toggle-text">Option pour le paiement de la TVA d'apres les debits</span>
								</label>
								<p class="wcef-field-desc">Si vous avez opte pour la TVA sur les debits, cette mention sera ajoutee a vos factures (reforme 2026).</p>
							</div>
						</div>
					</div>
				</div>

				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Conditions de paiement</h2>
						<p>Obligatoire sur les factures B2B (art. L441-9 du Code de commerce).</p>
					</div>
					<div class="wcef-card-body">
						<div class="wcef-field-row">
							<div class="wcef-field">
								<label for="wcef_payment_delay">Delai de paiement</label>
								<select id="wcef_payment_delay" name="wcef_payment_delay">
									<?php foreach ( WCEF_Settings::get_payment_delays() as $val => $label ) : ?>
										<option value="<?php echo esc_attr( $val ); ?>" <?php selected( get_option( 'wcef_payment_delay', '30' ), $val ); ?>><?php echo esc_html( $label ); ?></option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>

						<div class="wcef-field-row">
							<div class="wcef-field wcef-field-wide">
								<label for="wcef_penalty_rate">Taux de penalites de retard</label>
								<input type="text" id="wcef_penalty_rate" name="wcef_penalty_rate" value="<?php echo esc_attr( get_option( 'wcef_penalty_rate', "3x le taux d'interet legal" ) ); ?>" class="regular-text">
								<p class="wcef-field-desc">Mention obligatoire B2B. Ex : « 3x le taux d'interet legal » ou « 12% »</p>
							</div>
						</div>

						<div class="wcef-field-row">
							<div class="wcef-field wcef-field-wide">
								<label for="wcef_early_payment">Escompte pour paiement anticipe</label>
								<input type="text" id="wcef_early_payment" name="wcef_early_payment" value="<?php echo esc_attr( get_option( 'wcef_early_payment', "Pas d'escompte pour paiement anticipe" ) ); ?>" class="regular-text">
								<p class="wcef-field-desc">Mention obligatoire B2B. Ex : « Escompte de 2% pour paiement sous 10 jours »</p>
							</div>
						</div>

						<div class="wcef-info-box">
							<strong>Indemnite forfaitaire de recouvrement : 40,00 EUR</strong>
							<p>Cette mention est automatiquement ajoutee a toutes vos factures (obligatoire B2B, art. D441-5).</p>
						</div>
					</div>
				</div>

				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Mentions complementaires</h2>
					</div>
					<div class="wcef-card-body">
						<div class="wcef-field-row">
							<div class="wcef-field wcef-field-wide">
								<label for="wcef_legal_mentions">Mentions supplementaires</label>
								<textarea id="wcef_legal_mentions" name="wcef_legal_mentions" rows="3" class="large-text"><?php echo esc_textarea( get_option( 'wcef_legal_mentions', '' ) ); ?></textarea>
								<p class="wcef-field-desc">Assurance professionnelle, eco-participation DEEE, garantie legale, RCP, etc.</p>
							</div>
						</div>
					</div>
				</div>

				<?php elseif ( 'design' === $active_tab ) : ?>
				<!-- ═══ TAB: DESIGN ═══ -->
				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Logo</h2>
					</div>
					<div class="wcef-card-body">
						<div class="wcef-field-row">
							<div class="wcef-field">
								<label class="wcef-toggle-label">
									<input type="checkbox" id="wcef_design_show_logo" name="wcef_design_show_logo" value="yes" <?php checked( get_option( 'wcef_design_show_logo', 'yes' ), 'yes' ); ?> class="wcef-preview-trigger">
									<span class="wcef-toggle-text">Afficher le logo</span>
								</label>
							</div>
						</div>

						<div class="wcef-field-row">
							<div class="wcef-field">
								<input type="hidden" id="wcef_logo_id" name="wcef_logo_id" value="<?php echo esc_attr( $logo_id ); ?>" class="wcef-preview-trigger">
								<div class="wcef-logo-picker">
									<?php if ( $logo_url ) : ?>
										<span id="wcef-logo-preview"><img src="<?php echo esc_url( $logo_url ); ?>" alt="Logo"></span>
										<button type="button" class="button wcef-select-logo">Changer</button>
										<button type="button" class="button wcef-remove-logo">Supprimer</button>
									<?php else : ?>
										<span id="wcef-logo-preview"></span>
										<button type="button" class="button wcef-select-logo">Choisir un logo</button>
									<?php endif; ?>
								</div>
							</div>
						</div>

						<div class="wcef-field-row">
							<div class="wcef-field">
								<label for="wcef_design_logo_max_height">Taille du logo</label>
								<div class="wcef-range-group">
									<input type="range" id="wcef_design_logo_max_height" name="wcef_design_logo_max_height" value="<?php echo esc_attr( get_option( 'wcef_design_logo_max_height', '18' ) ); ?>" min="8" max="40" step="1" class="wcef-preview-trigger">
									<span class="wcef-range-value" id="wcef-logo-size-value"><?php echo esc_html( get_option( 'wcef_design_logo_max_height', '18' ) ); ?>mm</span>
								</div>
								<p class="wcef-field-desc">Hauteur maximale du logo sur la facture (8-40mm).</p>
							</div>
						</div>
					</div>
				</div>

				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Couleurs et typographie</h2>
					</div>
					<div class="wcef-card-body">
						<div class="wcef-field-row wcef-field-row-2">
							<div class="wcef-field">
								<label for="wcef_design_accent">Couleur d'accent</label>
								<input type="color" id="wcef_design_accent" name="wcef_design_accent" value="<?php echo esc_attr( get_option( 'wcef_design_accent', '#6366f1' ) ); ?>" style="width:60px; height:36px; padding:2px;" class="wcef-preview-trigger">
							</div>
							<div class="wcef-field">
								<label for="wcef_design_font">Police</label>
								<select id="wcef_design_font" name="wcef_design_font" class="wcef-preview-trigger">
									<?php foreach ( WCEF_Settings::get_fonts() as $val => $label ) : ?>
										<option value="<?php echo esc_attr( $val ); ?>" <?php selected( get_option( 'wcef_design_font', 'Helvetica Neue' ), $val ); ?>><?php echo esc_html( $label ); ?></option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>
					</div>
				</div>

				<?php elseif ( 'chorus' === $active_tab ) : ?>
				<!-- ═══ TAB: CHORUS PRO ═══ -->
				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Connexion Chorus Pro (PISTE)</h2>
						<p>Configurez vos identifiants pour transmettre vos factures au secteur public (B2G) via l'API Chorus Pro / PISTE.</p>
					</div>
					<div class="wcef-card-body">
						<?php if ( ! WCEF_License::can( 'routage_pa' ) ) : ?>
						<div class="wcef-upsell-banner">
							<strong>Fonctionnalite reservee aux plans Essentiel et superieurs.</strong>
							<p>Le routage vers Chorus Pro necessite un plan avec transmission. <a href="https://efacturx.com/#tarifs" target="_blank">Voir les offres</a></p>
						</div>
						<?php else : ?>
						<div class="wcef-field-row">
							<div class="wcef-field wcef-field-wide">
								<label for="wcef_chorus_environment">Environnement</label>
								<select id="wcef_chorus_environment" name="wcef_chorus_environment">
									<option value="sandbox" <?php selected( get_option( 'wcef_chorus_environment', 'sandbox' ), 'sandbox' ); ?>>Qualification (test)</option>
									<option value="production" <?php selected( get_option( 'wcef_chorus_environment', 'sandbox' ), 'production' ); ?>>Production</option>
								</select>
								<p class="wcef-field-desc">Utilisez l'environnement de qualification pour tester avant de passer en production. <strong>Attention :</strong> l'application PISTE de production est differente de celle de qualification.</p>
							</div>
						</div>

						<div class="wcef-field-row wcef-field-row-2">
							<div class="wcef-field">
								<label for="wcef_chorus_client_id">Client ID (PISTE)</label>
								<input type="text" id="wcef_chorus_client_id" name="wcef_chorus_client_id" value="<?php echo esc_attr( get_option( 'wcef_chorus_client_id', '' ) ); ?>" placeholder="Votre Client ID PISTE">
							</div>
							<div class="wcef-field">
								<label for="wcef_chorus_client_secret">Client Secret (PISTE)</label>
								<input type="password" id="wcef_chorus_client_secret" name="wcef_chorus_client_secret" value="<?php echo esc_attr( get_option( 'wcef_chorus_client_secret', '' ) ); ?>" placeholder="Votre Client Secret">
							</div>
						</div>

						<div class="wcef-field-row wcef-field-row-2">
							<div class="wcef-field">
								<label for="wcef_chorus_tech_login">Login technique (Chorus Pro)</label>
								<input type="text" id="wcef_chorus_tech_login" name="wcef_chorus_tech_login" value="<?php echo esc_attr( get_option( 'wcef_chorus_tech_login', '' ) ); ?>" placeholder="Votre login technique">
							</div>
							<div class="wcef-field">
								<label for="wcef_chorus_tech_password">Mot de passe technique</label>
								<input type="password" id="wcef_chorus_tech_password" name="wcef_chorus_tech_password" value="<?php echo esc_attr( get_option( 'wcef_chorus_tech_password', '' ) ); ?>" placeholder="Votre mot de passe">
							</div>
						</div>

						<div class="wcef-field-row">
							<div class="wcef-field">
								<label for="wcef_chorus_structure_id">ID Structure</label>
								<input type="text" id="wcef_chorus_structure_id" name="wcef_chorus_structure_id" value="<?php echo esc_attr( get_option( 'wcef_chorus_structure_id', '' ) ); ?>" placeholder="Identifiant de votre structure sur Chorus Pro">
								<p class="wcef-field-desc">L'identifiant de votre structure dans Chorus Pro (visible dans votre espace).</p>
							</div>
						</div>

						<div style="margin-top: 16px;">
							<button type="button" class="button" id="wcef-test-chorus">Tester la connexion</button>
							<span id="wcef-chorus-test-result" style="margin-left: 12px;"></span>
						</div>
						<?php endif; ?>
					</div>
				</div>

				<?php if ( WCEF_License::can( 'routage_pa' ) ) : ?>
				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Cle API REST</h2>
						<p>Generez une cle pour acceder a l'API REST du plugin (GET /wcef/v1/invoices).</p>
					</div>
					<div class="wcef-card-body">
						<div class="wcef-field-row">
							<div class="wcef-field wcef-field-wide">
								<label>Cle API</label>
								<div style="display: flex; gap: 8px; align-items: start;">
									<input type="text" id="wcef_api_key_display" value="<?php echo esc_attr( get_option( 'wcef_api_key', '' ) ); ?>" readonly style="flex: 1; font-family: monospace;">
									<button type="button" class="button" id="wcef-generate-api-key">Generer</button>
								</div>
								<p class="wcef-field-desc">Utilisez l'en-tete <code>X-WCEF-API-Key</code> pour authentifier vos requetes API.</p>
							</div>
						</div>
					</div>
				</div>
				<?php endif; ?>

				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Guide de configuration PISTE</h2>
					</div>
					<div class="wcef-card-body">
						<ol style="margin: 0; padding-left: 20px; line-height: 1.8;">
							<li>Creez un compte sur <a href="https://piste.gouv.fr/" target="_blank" rel="noopener">PISTE (piste.gouv.fr)</a> — portail des API de l'Etat</li>
							<li>Creez une <strong>application PISTE</strong> et abonnez-vous aux API <strong>Chorus Pro</strong> (facturation)</li>
							<li>Recuperez votre <strong>Client ID</strong> et <strong>Client Secret</strong></li>
							<li>Dans <a href="https://qualif.chorus-pro.gouv.fr/" target="_blank" rel="noopener">Chorus Pro qualification</a> (ou <a href="https://chorus-pro.gouv.fr/" target="_blank" rel="noopener">production</a>), creez un <strong>compte technique</strong> avec les droits API</li>
							<li><strong>Declarez le raccordement API</strong> dans Chorus Pro : menu Raccordements &gt; associez votre application PISTE a votre structure (etape souvent oubliee)</li>
							<li>Renseignez l'<strong>ID de votre structure</strong> Chorus Pro (visible dans votre espace)</li>
							<li>Renseignez tous les champs ci-dessus et testez la connexion</li>
						</ol>
						<div class="wcef-info-box" style="margin-top: 12px;">
							<strong>B2G uniquement</strong> — Chorus Pro gere la facturation vers le secteur public (B2G). Pour la facturation B2B entre entreprises privees (reforme 2026), une Plateforme de Dematerialisation Partenaire (PDP) sera necessaire.
						</div>
						<div class="wcef-info-box" style="margin-top: 8px;">
							<strong>Qualification ≠ Production</strong> — Vous devez creer une application PISTE <strong>separee</strong> pour la production. Les identifiants de qualification ne fonctionnent pas en production.
						</div>
					</div>
				</div>

				<?php elseif ( 'support' === $active_tab ) : ?>
				<!-- ═══ TAB: SUPPORT ═══ -->
				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Documentation</h2>
					</div>
					<div class="wcef-card-body">
						<p>Consultez la documentation complete du plugin pour tout savoir sur la configuration, les formats de factures et l'integration avec Chorus Pro.</p>
						<a href="https://efacturx.com/docs" target="_blank" rel="noopener" class="button button-primary">Acceder a la documentation</a>
					</div>
				</div>

				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Contacter le support</h2>
					</div>
					<div class="wcef-card-body">
						<?php
						$support_subject = rawurlencode( 'Support E-Facturation v' . WCEF_VERSION . ' - ' . home_url() );
						$support_body    = rawurlencode( "Bonjour,\n\nPlan: " . WCEF_License::get_full_plan_label() . "\nVersion plugin: " . WCEF_VERSION . "\nSite: " . home_url() . "\n\nMa question:\n" );
						?>
						<p>Notre equipe repond sous 24h (jours ouvres) pour les plans payants.</p>
						<a href="mailto:support@efacturx.com?subject=<?php echo esc_attr( $support_subject ); ?>&body=<?php echo esc_attr( $support_body ); ?>" class="button">Envoyer un email au support</a>
					</div>
				</div>

				<div class="wcef-card">
					<div class="wcef-card-header">
						<h2>Informations systeme</h2>
					</div>
					<div class="wcef-card-body">
						<textarea readonly rows="10" class="large-text" style="font-family: monospace; font-size: 12px;"><?php
							echo 'Plugin: E-Facturation France v' . esc_html( WCEF_VERSION ) . "\n";
							echo 'Plan: ' . esc_html( WCEF_License::get_full_plan_label() ) . "\n";
							echo 'Routing: ' . esc_html( WCEF_License::get_routing() ) . "\n";
							echo 'Chorus Pro: ' . ( WCEF_Chorus_Pro::is_configured() ? 'Configure (' . esc_html( WCEF_Chorus_Pro::get_environment() ) . ')' : 'Non configure' ) . "\n";
							echo 'WordPress: ' . esc_html( get_bloginfo( 'version' ) ) . "\n";
							echo 'WooCommerce: ' . ( defined( 'WC_VERSION' ) ? esc_html( WC_VERSION ) : 'N/A' ) . "\n";
							echo 'PHP: ' . esc_html( PHP_VERSION ) . "\n";
							echo 'Site: ' . esc_html( home_url() ) . "\n";
							echo 'Theme: ' . esc_html( wp_get_theme()->get( 'Name' ) ) . "\n";
						?></textarea>
					</div>
				</div>

				<?php endif; ?>

				<div class="wcef-save-bar">
					<button type="submit" class="button button-primary wcef-save-btn" id="wcef-save-btn">
						Enregistrer les reglages
					</button>
					<span class="wcef-save-status" id="wcef-save-status"></span>
				</div>
			</form>
		</div>

		<div class="wcef-settings-preview">
			<div class="wcef-preview-card">
				<div class="wcef-preview-header">
					<h3>Apercu facture</h3>
					<button type="button" class="button button-small" id="wcef-refresh-preview">Rafraichir</button>
				</div>
				<div class="wcef-preview-container" id="wcef-preview-container">
					<div class="wcef-preview-loading" id="wcef-preview-loading">
						<span class="spinner is-active"></span>
						Chargement de l'apercu...
					</div>
					<iframe id="wcef-preview-iframe" class="wcef-preview-iframe"></iframe>
				</div>
				<div class="wcef-preview-hint">
					Apercu en temps reel. Enregistrez pour appliquer aux futures factures.
				</div>
			</div>
		</div>
	</div>
</div>
