<?php
defined( 'ABSPATH' ) || exit;

$stats = WCEF_Supplier_Invoice::get_stats();
?>
<div class="wrap wcef-invoices-wrap">

	<h1 class="wp-heading-inline"><?php esc_html_e( 'Factures fournisseurs', 'wc-efacturation-france' ); ?></h1>

	<?php if ( WCEF_Chorus_Pro::is_configured() ) : ?>
		<button type="button" class="page-title-action" id="wcef-sync-suppliers">
			<?php esc_html_e( 'Synchroniser avec Chorus Pro', 'wc-efacturation-france' ); ?>
		</button>
		<span id="wcef-sync-status" style="display:none; margin-left: 12px; font-size: 13px;"></span>
	<?php else : ?>
		<p class="description" style="margin-top: 12px;">
			<?php
			printf(
				/* translators: %s: link to settings */
				esc_html__( 'Configurez vos identifiants Chorus Pro dans %s pour synchroniser les factures fournisseurs.', 'wc-efacturation-france' ),
				'<a href="' . esc_url( admin_url( 'admin.php?page=wcef-settings&tab=chorus' ) ) . '">' . esc_html__( 'Reglages > Chorus Pro', 'wc-efacturation-france' ) . '</a>'
			);
			?>
		</p>
	<?php endif; ?>

	<hr class="wp-header-end">

	<!-- Stats -->
	<div class="wcef-stats" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 16px; margin: 20px 0;">
		<div class="wcef-stat-card">
			<div class="stat-label"><?php esc_html_e( 'Total recues', 'wc-efacturation-france' ); ?></div>
			<div class="stat-value" data-target="<?php echo esc_attr( $stats['total'] ); ?>"><?php echo esc_html( $stats['total'] ); ?></div>
		</div>
		<div class="wcef-stat-card">
			<div class="stat-label"><?php esc_html_e( 'Ce mois', 'wc-efacturation-france' ); ?></div>
			<div class="stat-value" data-target="<?php echo esc_attr( $stats['this_month'] ); ?>"><?php echo esc_html( $stats['this_month'] ); ?></div>
		</div>
	</div>

	<!-- List Table -->
	<form method="get">
		<input type="hidden" name="page" value="wcef-suppliers">
		<?php
		$list_table->search_box( __( 'Rechercher', 'wc-efacturation-france' ), 'wcef-supplier-search' );
		$list_table->display();
		?>
	</form>

</div>
